/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PIHMCStringDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommandsTask;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.websm.launch.hscmgt.SystemConfigurationOverview;
import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class HMCList
extends HMCCommandsTask {
    private static final String HOSTNAME_FORMAT = "hostname";
    private static final String DOMAIN_FORMAT = "domain";
    private static final String NAMESERVER_FORMAT = "nameserver";
    private static final String DOMAINSUFFIX_FORMAT = "domainsuffix";
    private static final String GATEWAY_FORMAT = "gateway";
    private static final String IPADDR_FORMAT = "ipaddr";
    private static final String IPADDRLPAR_FORMAT = "ipaddrlpar";
    private static final String NETMASK_FORMAT = "networkmask";
    private static final String NETMASKLPAR_FORMAT = "networkmasklpar";
    private static final String DHCP_CLIENTS_FORMAT = "clients";
    private static final String[] validNetwork = new String[]{"hostname", "domain", "ipaddr", "networkmask", "gateway", "nameserver", "domainsuffix", "ipaddrlpar", "networkmasklpar", "clients"};
    private static final String SSH_FORMAT = "ssh";
    private static final String XNTP_FORMAT = "xntp";
    private static final String WEBSM_FORMAT = "websm";
    private static final String HTTP_FORMAT = "http";
    private static final String[] validRemote = new String[]{"ssh", "xntp", "websm", "http"};
    private static final String VERSION_FORMAT = "version";
    private static final String[] validVersion = new String[]{"version"};
    private static final String VPD_FORMAT = "vpd";
    private static final String[] validVPD = new String[]{"vpd"};
    private static final String BIOS_FORMAT = "bios";
    private static final String[] validBIOS = new String[]{"bios"};
    private static final String TYPE_FORMAT = "type";
    private static final String[] validType = new String[]{"type"};
    private static final String[] validRegatta = new String[]{"hostname", "domain", "ipaddr", "networkmask", "gateway", "nameserver", "domainsuffix", "ipaddrlpar", "networkmasklpar", "clients", "ssh", "websm", "http"};
    private static final String DHCP_LEASES_FILE = "/var/lib/dhcp/dhcpd.leases";
    private static final String LEASE_STR = "lease";
    private static final String FAILOVER_STR = "failover";
    private static final String GROUP_STR = "group";
    private static final String SUBGROUP_STR = "subgroup";
    private static final String HOST_STR = "host";
    private static final String OPEN_BRACE_STR = "{";
    private static final String CLOSE_BRACE_STR = "}";
    private static final String STARTS_STR = "starts";
    private static final String ENDS_STR = "ends";
    private static final String ABANDONED_STR = "abandoned";
    private boolean showNetwork;
    private boolean showVPD;
    private boolean showBIOS;
    private boolean showVersion;
    private boolean showRemote;
    private boolean showHmcType;
    private String[] validKeys;
    private String[] actualKeys;
    private static final int NUM_VALID_PARMS = 7;
    private HashMap m_validParms = new HashMap(15, 0.5f);
    private boolean m_writeStatus;
    private boolean m_header;
    private String m_delimiter;
    private String m_format;

    public HMCList() {
    }

    private HMCList(PIHSCCECClient pIHSCCECClient, boolean bl) {
        this.m_writeStatus = bl;
        this.m_header = false;
        this.m_delimiter = ",";
        this.m_format = null;
        this.m_validParms.put(HMCCommandUtils.NETWORK_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.REMOTE_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.HMC_VERSION_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.VPD_PARAM, null);
        this.m_validParms.put(HMCCommandUtils.BIOS_PARAM, null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
        this.m_validParms.put(HMCCommandUtils.TYPE_PARAM, null);
    }

    public String getNextToken(StreamTokenizer streamTokenizer) throws IOException, PIHscClientException {
        int n = streamTokenizer.nextToken();
        if (n != -3) {
            String[] stringArray = new String[]{DHCP_LEASES_FILE};
            throw new PIHscClientException("8016", "PIHscCmdLineBundle", "FILE_INVALID", stringArray, null);
        }
        return streamTokenizer.sval;
    }

    public void skipToCloseBrace(StreamTokenizer streamTokenizer) throws IOException, PIHscClientException {
        boolean bl = false;
        while (!bl) {
            String string = this.getNextToken(streamTokenizer);
            if (string.equalsIgnoreCase(CLOSE_BRACE_STR)) {
                bl = true;
                continue;
            }
            if (!string.equalsIgnoreCase(OPEN_BRACE_STR)) continue;
            this.skipToCloseBrace(streamTokenizer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] readDHCPLeases() throws PIHscClientException {
        String string = null;
        String string2 = null;
        StreamTokenizer streamTokenizer = null;
        String string3 = null;
        String string4 = null;
        Date date = null;
        Date date2 = null;
        Date date3 = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        boolean bl2 = false;
        File file = new File(DHCP_LEASES_FILE);
        if (!file.exists()) {
            return null;
        }
        try {
            streamTokenizer = new StreamTokenizer(new InputStreamReader(new FileInputStream(DHCP_LEASES_FILE)));
            streamTokenizer.ordinaryChars(33, 255);
            streamTokenizer.wordChars(33, 255);
            streamTokenizer.commentChar(35);
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.sval.equalsIgnoreCase(LEASE_STR)) {
                    string2 = this.getNextToken(streamTokenizer);
                    string = this.getNextToken(streamTokenizer);
                    if (!string.equalsIgnoreCase(OPEN_BRACE_STR)) {
                        String[] stringArray2 = new String[]{DHCP_LEASES_FILE};
                        throw new PIHscClientException("8016", "PIHscCmdLineBundle", "FILE_INVALID", stringArray2, null);
                    }
                    date = null;
                    date2 = null;
                    bl = false;
                    string = this.getNextToken(streamTokenizer);
                } else {
                    string = this.getNextToken(streamTokenizer);
                    while (!string.equalsIgnoreCase(OPEN_BRACE_STR)) {
                        string = this.getNextToken(streamTokenizer);
                    }
                    this.skipToCloseBrace(streamTokenizer);
                    continue;
                }
                while (!string.equalsIgnoreCase(CLOSE_BRACE_STR)) {
                    block19: {
                        try {
                            if (string.endsWith(";")) {
                                string = string.substring(0, string.length() - 1);
                            }
                            if (string.equalsIgnoreCase(ABANDONED_STR)) {
                                bl = true;
                                break block19;
                            }
                            if (string.equalsIgnoreCase(STARTS_STR)) {
                                string = this.getNextToken(streamTokenizer);
                                string3 = this.getNextToken(streamTokenizer);
                                if ((string3 = string3 + " " + this.getNextToken(streamTokenizer)).endsWith(";")) {
                                    string3 = string3.substring(0, string3.length() - 1);
                                }
                                string3 = string3 + " UTC";
                                date = simpleDateFormat.parse(string3);
                                break block19;
                            }
                            if (string.equalsIgnoreCase(ENDS_STR)) {
                                string = this.getNextToken(streamTokenizer);
                                string4 = this.getNextToken(streamTokenizer);
                                if ((string4 = string4 + " " + this.getNextToken(streamTokenizer)).endsWith(";")) {
                                    string4 = string4.substring(0, string4.length() - 1);
                                }
                                string4 = string4 + " UTC";
                                date2 = simpleDateFormat.parse(string4);
                                break block19;
                            }
                            if (string.equalsIgnoreCase(OPEN_BRACE_STR)) {
                                this.skipToCloseBrace(streamTokenizer);
                            }
                        }
                        catch (ParseException parseException) {
                            String[] stringArray3 = new String[]{DHCP_LEASES_FILE};
                            throw new PIHscClientException("8016", "PIHscCmdLineBundle", "FILE_INVALID", stringArray3, null);
                        }
                    }
                    string = this.getNextToken(streamTokenizer);
                }
                int n = arrayList.indexOf(string2);
                if (!bl && date != null && date.before(date3) && date2 != null && date2.after(date3)) {
                    if (n != -1) continue;
                    arrayList.add(string2);
                    continue;
                }
                if (n == -1) continue;
                arrayList.remove(n);
            }
        }
        catch (IOException iOException) {
            String[] stringArray4 = new String[]{DHCP_LEASES_FILE};
            throw new PIHscClientException("8016", "PIHscCmdLineBundle", "IO_EXCEPTION", stringArray4, null);
        }
        if (arrayList.isEmpty()) return stringArray;
        return arrayList.toArray(new String[0]);
    }

    private int invokeCommand() throws Exception {
        int n = 0;
        if (this.showRemote || this.showVPD || this.showVersion || this.showHmcType || this.showBIOS) {
            PIHscUtil.initHscUtil(3);
            this.taskletOutput = new Vector();
            this.performCommand();
        } else {
            n = this.invokeViaTasklet();
        }
        return n;
    }

    public void performCommand() throws Exception {
        Object object;
        String[] stringArray;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        String[] stringArray5 = stringArray = new String[]{""};
        String[] stringArray6 = stringArray;
        String[] stringArray7 = stringArray;
        Object var19_19 = null;
        int n = 0;
        int n2 = 0;
        String[] stringArray8 = stringArray;
        String[] stringArray9 = stringArray;
        String[] stringArray10 = stringArray;
        string2 = "enable";
        string3 = "disable";
        if (this.showNetwork) {
            List list;
            NetworkInfo networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
            string4 = networkInfo.getComputerName();
            string5 = networkInfo.getDomainName();
            string6 = networkInfo.getDefaultGateway();
            stringArray2 = networkInfo.getDNSServers();
            if (stringArray2 == null || stringArray2.length == 0) {
                stringArray2 = stringArray;
            }
            if ((stringArray3 = networkInfo.getDomainSuffixes()) == null || stringArray3.length == 0) {
                stringArray3 = stringArray;
            }
            if ((n = (list = NetworkSettings.getNetworkSettings().getNetworkInterfaceInfo()).size()) > 0) {
                int n3;
                stringArray5 = new String[n];
                stringArray6 = new String[n];
                stringArray7 = new String[n];
                object = null;
                for (n3 = 0; n3 < list.size(); ++n3) {
                    object = (NetworkInterfaceInformation)list.get(n3);
                    stringArray5[n3] = object.getIpAddress().getHostAddress();
                    stringArray6[n3] = object.getNetworkMask().getHostAddress();
                    stringArray7[n3] = object.getIfname();
                    if (!object.isPartitionCommunication()) continue;
                    if (n2 == 0) {
                        stringArray8 = new String[n];
                        stringArray9 = new String[n];
                        stringArray10 = new String[n];
                    }
                    stringArray8[n2] = stringArray5[n3];
                    stringArray9[n2] = stringArray6[n3];
                    stringArray10[n2] = stringArray7[n3];
                    ++n2;
                }
                for (n3 = 0; n3 < list.size(); ++n3) {
                    object = (NetworkInterfaceInformation)list.get(n3);
                    if (object.isPartitionCommunication() || object.isPrivateIf()) continue;
                    if (n2 == 0) {
                        stringArray8 = new String[n];
                        stringArray9 = new String[n];
                        stringArray10 = new String[n];
                    }
                    stringArray8[n2] = stringArray5[n3];
                    stringArray9[n2] = stringArray6[n3];
                    stringArray10[n2] = stringArray7[n3];
                    ++n2;
                }
            }
            if ((stringArray4 = this.readDHCPLeases()) == null) {
                stringArray4 = stringArray;
            }
            object = new PIHMCStringDataBean(this.validKeys);
            ((PIHMCStringDataBean)object).setKeyValue(HOSTNAME_FORMAT, string4);
            ((PIHMCStringDataBean)object).setKeyValue(IPADDR_FORMAT, HMCCommandUtils.flattenArray(stringArray5, n));
            ((PIHMCStringDataBean)object).setKeyValue(NETMASK_FORMAT, HMCCommandUtils.flattenArray(stringArray6, n));
            ((PIHMCStringDataBean)object).setKeyValue(GATEWAY_FORMAT, string6);
            ((PIHMCStringDataBean)object).setKeyValue(DOMAIN_FORMAT, string5);
            ((PIHMCStringDataBean)object).setKeyValue(NAMESERVER_FORMAT, HMCCommandUtils.flattenArray(stringArray2, stringArray2.length));
            ((PIHMCStringDataBean)object).setKeyValue(DOMAINSUFFIX_FORMAT, HMCCommandUtils.flattenArray(stringArray3, stringArray3.length));
            ((PIHMCStringDataBean)object).setKeyValue(IPADDRLPAR_FORMAT, HMCCommandUtils.flattenArray(stringArray8, n2));
            ((PIHMCStringDataBean)object).setKeyValue(NETMASKLPAR_FORMAT, HMCCommandUtils.flattenArray(stringArray9, n2));
            ((PIHMCStringDataBean)object).setKeyValue(DHCP_CLIENTS_FORMAT, HMCCommandUtils.flattenArray(stringArray4, stringArray4.length));
            this.taskletOutput.addElement(object);
        }
        if (this.showRemote) {
            object = SystemConfigurationOverview.sshEnabled();
            string7 = ((Boolean)object).booleanValue() ? string2 : string3;
            string8 = this._isServiceRunning(WEBSM_FORMAT) ? string2 : string3;
            string10 = this._isServiceRunning(HTTP_FORMAT) ? string2 : string3;
            string9 = this._isServiceRunning(XNTP_FORMAT) ? string2 : string3;
            PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.validKeys);
            pIHMCStringDataBean.setKeyValue(SSH_FORMAT, string7);
            pIHMCStringDataBean.setKeyValue(XNTP_FORMAT, string9);
            pIHMCStringDataBean.setKeyValue(WEBSM_FORMAT, string8);
            pIHMCStringDataBean.setKeyValue(HTTP_FORMAT, string10);
            this.taskletOutput.addElement(pIHMCStringDataBean);
        }
        if (this.showVPD) {
            try {
                object = CIMUtils.getVPD();
            }
            catch (Exception exception) {
                throw new HSCException(exception);
            }
            PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.validKeys);
            pIHMCStringDataBean.setKeyValue(VPD_FORMAT, (String)object);
            this.taskletOutput.addElement(pIHMCStringDataBean);
        }
        if (this.showVersion) {
            object = EExec.Exec((String)"/opt/hsc/bin/hsc version");
            if (object != null && ((EExecResult)object).rc == 0) {
                PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.validKeys);
                pIHMCStringDataBean.setKeyValue(VERSION_FORMAT, ((EExecResult)object).stdout);
                this.taskletOutput.addElement(pIHMCStringDataBean);
            } else {
                throw new HSCException(((EExecResult)object).stderr);
            }
        }
        if (this.showBIOS) {
            object = EExec.Exec((String)"/opt/hsc/bin/SystemSettings bios view");
            if (object != null && ((EExecResult)object).rc == 0) {
                PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.validKeys);
                pIHMCStringDataBean.setKeyValue(BIOS_FORMAT, ((EExecResult)object).stdout);
                this.taskletOutput.addElement(pIHMCStringDataBean);
            } else {
                throw new HSCException(((EExecResult)object).stderr);
            }
        }
        if (this.showHmcType) {
            object = new File("/opt/hsc/data/hmcType.properties");
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream((File)object));
                string11 = properties.getProperty("HMCTYPE", "UNKNOWN");
            }
            catch (IOException iOException) {
                string11 = "UNKNOWN";
            }
            PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.validKeys);
            pIHMCStringDataBean.setKeyValue(TYPE_FORMAT, string11);
            this.taskletOutput.addElement(pIHMCStringDataBean);
        }
    }

    public void mapParameters(HashMap hashMap) throws PIHscClientException {
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var5_5 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = 0;
        String string8 = "";
        this.showNetwork = false;
        this.showRemote = false;
        this.showVPD = false;
        this.showBIOS = false;
        this.showVersion = false;
        this.showHmcType = false;
        string3 = (String)hashMap.get(HMCCommandUtils.REMOTE_PARAM);
        string = (String)hashMap.get(HMCCommandUtils.VPD_PARAM);
        string2 = (String)hashMap.get(HMCCommandUtils.NETWORK_PARAM);
        string4 = (String)hashMap.get(HMCCommandUtils.HMC_VERSION_PARAM);
        this.m_format = (String)hashMap.get(HMCCommandUtils.FORMAT_PARAM);
        string6 = (String)hashMap.get("--header");
        string7 = (String)hashMap.get(HMCCommandUtils.TYPE_PARAM);
        string5 = (String)hashMap.get(HMCCommandUtils.BIOS_PARAM);
        if (string2 != null) {
            if (string2.length() > 0) {
                String[] stringArray = new String[]{HMCCommandUtils.REMOTE_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.showNetwork = true;
            this.validKeys = validNetwork;
            if (n != 0) {
                string8 = string8 + ", ";
            }
            string8 = string8 + HMCCommandUtils.NETWORK_PARAM;
            ++n;
        }
        if (string != null) {
            if (string.length() > 0) {
                String[] stringArray = new String[]{HMCCommandUtils.VPD_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.showVPD = true;
            this.validKeys = validVPD;
            if (n != 0) {
                string8 = string8 + ", ";
            }
            string8 = string8 + HMCCommandUtils.VPD_PARAM;
            ++n;
        }
        if (string3 != null) {
            if (string3.length() > 0) {
                String[] stringArray = new String[]{HMCCommandUtils.REMOTE_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.showRemote = true;
            this.validKeys = validRemote;
            if (n != 0) {
                string8 = string8 + ", ";
            }
            string8 = string8 + HMCCommandUtils.REMOTE_PARAM;
            ++n;
        }
        if (string5 != null) {
            if (string5.length() > 0) {
                String[] stringArray = new String[]{HMCCommandUtils.BIOS_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.showBIOS = true;
            this.validKeys = validBIOS;
            if (n != 0) {
                string8 = string8 + ", ";
            }
            string8 = string8 + HMCCommandUtils.BIOS_PARAM;
            ++n;
        }
        if (string4 != null) {
            if (string4.length() > 0) {
                String[] stringArray = new String[]{HMCCommandUtils.HMC_VERSION_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.showVersion = true;
            this.validKeys = validVersion;
            if (n != 0) {
                string8 = string8 + ", ";
            }
            string8 = string8 + HMCCommandUtils.HMC_VERSION_PARAM;
            ++n;
        }
        if (string7 != null) {
            if (string7.length() > 0) {
                String[] stringArray = new String[]{HMCCommandUtils.TYPE_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.showHmcType = true;
            this.validKeys = validType;
            if (n != 0) {
                string8 = string8 + ", ";
            }
            string8 = string8 + HMCCommandUtils.TYPE_PARAM;
            ++n;
        }
        if (n == 0) {
            String[] stringArray = new String[]{HMCCommandUtils.NETWORK_PARAM + ", " + HMCCommandUtils.VPD_PARAM + ", " + HMCCommandUtils.HMC_VERSION_PARAM + ", " + HMCCommandUtils.REMOTE_PARAM};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (n > 1) {
            if (n == 2 && this.showNetwork && this.showRemote && this.m_format != null) {
                this.validKeys = validRegatta;
            } else {
                String[] stringArray = new String[]{string8};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
            }
        }
        if (this.m_format != null && this.m_format.length() > 0) {
            boolean bl = true;
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, this.validKeys, this.validKeys.length);
            if (this.m_delimiter.length() == 0) {
                bl = false;
                this.m_delimiter = ",";
            }
            this.actualKeys = PICmdOutputUtils.checkKeys(this.validKeys, this.m_format, this.m_delimiter);
            if (!bl && (this.actualKeys[0].equals(IPADDR_FORMAT) || this.actualKeys[0].equals(NETMASK_FORMAT) || this.actualKeys[0].equals(NAMESERVER_FORMAT) || this.actualKeys[0].equals(DOMAINSUFFIX_FORMAT) || this.actualKeys[0].equals(IPADDRLPAR_FORMAT) || this.actualKeys[0].equals(NETMASKLPAR_FORMAT) || this.actualKeys[0].equals(DHCP_CLIENTS_FORMAT))) {
                this.m_delimiter = ";";
            }
        } else {
            this.actualKeys = this.validKeys;
        }
        if (string6 != null) {
            if (this.m_format == null) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
            }
            if (string6.trim().length() != 0) {
                String[] stringArray = new String[]{"--header"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.m_header = true;
        }
    }

    public void printResults(int n, PrintStream printStream) {
        PICmdOutputUtils.printResults(printStream, this.m_writeStatus, this.taskletOutput.elements(), this.actualKeys, this.m_delimiter, this.m_header, this.m_format == null);
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSHMC_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        HMCList hMCList = new HMCList(pIHSCCECClient, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, hMCList.m_validParms);
            hMCList.mapParameters(hashMap);
            n = hMCList.invokeCommand();
            hMCList.printResults(n, printStream);
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                pIHscClientException.printStackTrace(printStream);
                String string = pIHscClientException.getMessage();
                if (string == null) {
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            exception.printStackTrace(printStream);
            String string = exception.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            printStream.println(string);
            n = 1;
        }
        return n;
    }

    private boolean _isServiceRunning(String string) {
        EExecResult eExecResult = null;
        if (string.equals(WEBSM_FORMAT)) {
            eExecResult = EExec.Exec((String)"/opt/hsc/bin/SystemSettings websm view");
        } else if (string.equals(HTTP_FORMAT)) {
            eExecResult = EExec.Exec((String)"/opt/hsc/bin/SystemSettings http view");
        } else if (string.equals(XNTP_FORMAT)) {
            eExecResult = EExec.Exec((String)"/opt/hsc/bin/SystemSettings xntp view");
        }
        return eExecResult != null && eExecResult.rc == 0;
    }
}

